
CREATE OR REPLACE FUNCTION addColumn()
RETURNS VOID AS
$BODY$
BEGIN
    IF EXISTS (SELECT 1                  
				FROM 
					information_schema.columns     
                WHERE 
					table_name ilike ('glb_layout_filipeta')
					and column_name ilike ('msg_mk')
	) THEN
         RAISE NOTICE 'Coluna  msg_mk  na tabela  glb_layout_filipeta  ja existe!' ;
    ELSE
		ALTER TABLE public.glb_layout_filipeta ADD COLUMN msg_mk text COLLATE pg_catalog."default";
        RAISE NOTICE 'Coluna "msg_mk" criada com sucesso!';
    END IF;     
END;
-- fim bloco principal
$BODY$
LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION addColumn()  OWNER TO postgres;
SELECT addColumn();
DROP FUNCTION addColumn();
